/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.pt.ipc.events;

import com.cisco.pt.UUID;
import com.cisco.pt.impl.IPCEventLTV;
import com.cisco.pt.ipc.events.CiscoDeviceEvent;
import com.cisco.pt.ipc.events.CiscoDeviceEventListener;
import com.cisco.pt.ipc.events.IPCEventRegistry;
import com.cisco.pt.ipc.sim.CiscoDevice;
import com.cisco.pt.ptmp.PacketTracerSession;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CiscoDeviceEventRegistry
extends IPCEventRegistry {
    protected Set<CiscoDeviceEventListener> globalListeners = new HashSet<CiscoDeviceEventListener>();
    protected Map<String, Set<CiscoDeviceEventListener>> specificObjectListeners = new HashMap<String, Set<CiscoDeviceEventListener>>();
    private static Log logger = LogFactory.getLog(CiscoDeviceEventRegistry.class);

    public CiscoDeviceEventRegistry(PacketTracerSession session) {
        super(session);
    }

    @Override
    public String getClassName() {
        return "CiscoDevice";
    }

    @Override
    public void processEvent(IPCEventLTV event) throws Exception {
        String eventName = event.getEventName();
        CiscoDeviceEvent evt = null;
        if (eventName.equalsIgnoreCase("doneBooting")) {
            evt = new CiscoDeviceEvent.DoneBooting(event);
        } else if (eventName.equalsIgnoreCase("lineConnected")) {
            evt = new CiscoDeviceEvent.LineConnected(event);
        } else if (eventName.equalsIgnoreCase("lineDisconnected")) {
            evt = new CiscoDeviceEvent.LineDisconnected(event);
        } else if (eventName.equalsIgnoreCase("lineAuthenticationStarted")) {
            evt = new CiscoDeviceEvent.LineAuthenticationStarted(event);
        } else if (eventName.equalsIgnoreCase("lineAuthenticationFailed")) {
            evt = new CiscoDeviceEvent.LineAuthenticationFailed(event);
        } else if (eventName.equalsIgnoreCase("lineAuthenticationFinished")) {
            evt = new CiscoDeviceEvent.LineAuthenticationFinished(event);
        } else {
            logger.info((Object)("Unrecognized eventName for " + this.getClassName() + ": " + eventName));
            return;
        }
        for (CiscoDeviceEventListener listener : this.globalListeners) {
            listener.handleEvent(evt);
        }
        Set<CiscoDeviceEventListener> specificListeners = this.specificObjectListeners.get(evt.objectUUID.toString());
        if (specificListeners != null) {
            for (CiscoDeviceEventListener listener : specificListeners) {
                listener.handleEvent(evt);
            }
        }
    }

    public void addListenerFiltered(CiscoDeviceEventListener listener, List<String> events) throws IOException {
        if (this.globalListeners.size() == 0) {
            if (events == null) {
                this.register("doneBooting");
                this.register("lineConnected");
                this.register("lineDisconnected");
                this.register("lineAuthenticationStarted");
                this.register("lineAuthenticationFailed");
                this.register("lineAuthenticationFinished");
            } else {
                for (int i = 0; i < events.size(); ++i) {
                    this.register(events.get(i));
                }
            }
        }
        this.globalListeners.add(listener);
    }

    public void addSpecificListenerFiltered(CiscoDeviceEventListener listener, CiscoDevice objClass, List<String> events) throws IOException {
        UUID uuid = objClass.getObjectUUID();
        String uuidString = uuid.toString();
        Set<CiscoDeviceEventListener> specificListeners = this.specificObjectListeners.get(uuidString);
        if (specificListeners == null) {
            specificListeners = new HashSet<CiscoDeviceEventListener>();
            this.specificObjectListeners.put(uuidString, specificListeners);
            if (events == null) {
                this.register(uuid, "doneBooting");
                this.register(uuid, "lineConnected");
                this.register(uuid, "lineDisconnected");
                this.register(uuid, "lineAuthenticationStarted");
                this.register(uuid, "lineAuthenticationFailed");
                this.register(uuid, "lineAuthenticationFinished");
            } else {
                for (int i = 0; i < events.size(); ++i) {
                    this.register(uuid, events.get(i));
                }
            }
        }
        specificListeners.add(listener);
    }

    public void removeListenerFiltered(CiscoDeviceEventListener listener, List<String> events) throws IOException {
        if (this.globalListeners.size() != 0) {
            if (events == null) {
                this.deregister("doneBooting");
                this.deregister("lineConnected");
                this.deregister("lineDisconnected");
                this.deregister("lineAuthenticationStarted");
                this.deregister("lineAuthenticationFailed");
                this.deregister("lineAuthenticationFinished");
            }
            this.globalListeners.remove(listener);
        }
    }

    public void removeSpecificListenerFiltered(CiscoDeviceEventListener listener, CiscoDevice objClass, List<String> events) throws IOException {
        UUID uuid = objClass.getObjectUUID();
        String uuidString = uuid.toString();
        Set<CiscoDeviceEventListener> specificListeners = this.specificObjectListeners.get(uuidString);
        if (specificListeners != null && !specificListeners.isEmpty()) {
            this.deregister(uuid, "doneBooting");
            this.deregister(uuid, "lineConnected");
            this.deregister(uuid, "lineDisconnected");
            this.deregister(uuid, "lineAuthenticationStarted");
            this.deregister(uuid, "lineAuthenticationFailed");
            this.deregister(uuid, "lineAuthenticationFinished");
            specificListeners.remove(listener);
        }
    }

    public void addListener(CiscoDeviceEventListener listener) throws IOException {
        this.addListenerFiltered(listener, null);
    }

    public void addListener(CiscoDeviceEventListener listener, CiscoDevice objClass) throws IOException {
        this.addSpecificListenerFiltered(listener, objClass, null);
    }

    public void removeListener(CiscoDeviceEventListener listener) throws IOException {
        this.removeListenerFiltered(listener, null);
    }

    public void removeListener(CiscoDeviceEventListener listener, CiscoDevice objClass) throws IOException {
        this.removeSpecificListenerFiltered(listener, objClass, null);
    }
}

